; Script generated by the Inno Setup Script Wizard.
; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!

#define MyAppName "eirt"
#define MyAppVersion "1.3.0"
#define MyAppPublisher "Stephane Germain <germste@gmail.com>"
#define MyAppURL "http://libirt.sf.net"
#define MyAppURLFile "eirt.url"

[Setup]
AppName={#MyAppName}
AppVerName={#MyAppName}-{#MyAppVersion}
AppPublisher={#MyAppPublisher}
AppPublisherURL={#MyAppURL}
AppSupportURL={#MyAppURL}
AppUpdatesURL={#MyAppURL}
DefaultDirName={pf}\{#MyAppName}
DefaultGroupName={#MyAppName}
LicenseFile=..\COPYING.txt
OutputDir=..
OutputBaseFilename={#MyAppName}-{#MyAppVersion}
Compression=lzma
SolidCompression=yes
ChangesEnvironment=true

[Languages]
Name: french; MessagesFile: compiler:Languages\French.isl,French.isl
Name: English; MessagesFile: compiler:Default.isl,Default.isl

[Tasks]
Name: modifypath; Description: {cm:AddPathToEnv}
Name: securitylevel; Description: {cm:ChangeSecurityLevel}
Name: installaddin; Description: {cm:InstallAddInDescription}

[Files]
Source: ..\ChangeLog.txt; DestDir: {app}; Flags: ignoreversion
Source: ..\COPYING.txt; DestDir: {app}; Flags: ignoreversion
Source: ..\README.txt; DestDir: {app}; Flags: ignoreversion
Source: ..\TODO.txt; DestDir: {app}; Flags: ignoreversion
Source: ..\xls\*; DestDir: {app}\xls; Flags: ignoreversion recursesubdirs
Source: ..\doc\*; DestDir: {app}\doc; Flags: ignoreversion recursesubdirs
Source: ..\vba\*; DestDir: {app}\vba; Flags: ignoreversion recursesubdirs
Source: ..\bin\*; DestDir: {app}\bin; Flags: ignoreversion recursesubdirs
Source: ..\setup\*; DestDir: {app}\setup; Flags: ignoreversion recursesubdirs
Source: ..\examples\*; DestDir: {app}\examples; Flags: ignoreversion recursesubdirs

[Icons]
Name: {group}\{cm:InstallAddin}; Filename: {app}\xls\install-{#MyAppName}.xls
Name: {group}\{cm:Examples}\Binary; Filename: {app}\examples\Binary.xls
Name: {group}\{cm:Examples}\Graded; Filename: {app}\examples\Graded.xls
Name: {group}\{cm:Examples}\Nominal; Filename: {app}\examples\Nominal.xls
Name: {group}\{cm:OnTheWeb}; Filename: {app}\{#MyAppURLFile}
Name: {group}\{cm:Help}; Filename: {app}\doc\{#MyAppName}-{cm:LangAbbrev}.pdf
Name: {group}\{cm:UninstallProgram, {#MyAppName}}; Filename: {uninstallexe}
Name: {group}\{cm:UninstallAddin}; Filename: {app}\xls\uninstall-{#MyAppName}.xls

[Registry]
Root: HKCU; Subkey: Software\Microsoft\Office\9.0\Excel\Security; ValueType: dword; ValueName: Level; ValueData: 2; Tasks: securitylevel
Root: HKCU; Subkey: Software\Microsoft\Office\10.0\Excel\Security; ValueType: dword; ValueName: Level; ValueData: 2; Tasks: securitylevel
Root: HKCU; Subkey: Software\Microsoft\Office\11.0\Excel\Security; ValueType: dword; ValueName: Level; ValueData: 2; Tasks: securitylevel
Root: HKCU; Subkey: Software\Microsoft\Office\12.0\Excel\Security; ValueType: dword; ValueName: Level; ValueData: 1; Tasks: securitylevel
Root: HKCU; Subkey: Software\Microsoft\Office\13.0\Excel\Security; ValueType: dword; ValueName: Level; ValueData: 1; Tasks: securitylevel
Root: HKCU; Subkey: Software\Microsoft\Office\14.0\Excel\Security; ValueType: dword; ValueName: Level; ValueData: 1; Tasks: securitylevel
Root: HKCU; Subkey: Software\Microsoft\Office\15.0\Excel\Security; ValueType: dword; ValueName: Level; ValueData: 1; Tasks: securitylevel
Root: HKCU; Subkey: Software\VB and VBA Program Settings\{#MyAppName}\Config; ValueType: string; ValueName: LangCode; ValueData: {cm:LangCode}
Root: HKCU; Subkey: Software\VB and VBA Program Settings\{#MyAppName}\Config; ValueType: string; ValueName: Version; ValueData: {#MyAppVersion}

[Code]
		function ModPathDir(): String;
		begin
			Result := ExpandConstant('{app}\bin');
		end;
		#include "modpath.iss"

[INI]
Filename: {app}\{#MyAppURLFile}; Section: InternetShortcut; Key: URL; String: {#MyAppURL}

[UninstallDelete]
Type: files; Name: {app}\{#MyAppURLFile}

[Run]
Filename: {app}\xls\install-{#MyAppName}.xls; Description: {cm:InstallAddin}; Flags: shellexec; WorkingDir: {app}; Tasks: installaddin

[UninstallRun]
Filename: {app}\xls\uninstall-{#MyAppName}.xls; Flags: shellexec; WorkingDir: {app}
