VERSION 5.00
Begin {C62A69F0-16DC-11CE-9E98-00AA00574A4F} frmSettings 
   Caption         =   "wirt"
   ClientHeight    =   6090
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   8595
   OleObjectBlob   =   "frmSettings.frx":0000
   StartUpPosition =   1  'CenterOwner
End
Attribute VB_Name = "frmSettings"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

' Copyright (C) 2007 Stephane Germain <stephane.germain@gmail.com>
'
' This program is free software; you can redistribute it and/or modify
' it under the terms of the GNU General Public License as published by
' the Free Software Foundation; either version 2 of the License, or (at
' your option) any later version.
'
' This program is distributed in the hope that it will be useful, but
' WITHOUT ANY WARRANTY; without even the implied warranty of
' MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
' General Public License for more details.
'
' You should have received a copy of the GNU General Public License
' along with this program; if not, write to the Free Software
' Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

Option Explicit
Option Base 0

Private Function CheckSetting() As Boolean
    CheckSetting = True
    
    ' we validate the user input with locale dependant functions
    
    ' priors
    If CDbl(txtSlopeMean.Text) <= 0 Then
        MsgBox GText("msgNotPos", lblSlopeMean.Caption), vbApplicationModal, ProgName
        CheckSetting = False
    End If
    If CDbl(txtSlopeDev.Text) <= 0 Then
        MsgBox GText("msgNotPos", lblSlopeDev.Caption), vbApplicationModal, ProgName
        CheckSetting = False
    End If
    If CDbl(txtThreshDev.Text) <= 0 Then
        MsgBox GText("msgNotPos", lblThreshDev.Caption), vbApplicationModal, ProgName
        CheckSetting = False
    End If
    If CDbl(txtAsympMean.Text) <= 0 Or Val(txtAsympMean.Text) >= 1 Then
        MsgBox GText("msgOutside01", lblAsympMean.Caption), vbApplicationModal, ProgName
        CheckSetting = False
    End If
    If CDbl(txtAsympWeight.Text) <= 0 Then
        MsgBox GText("msgNotPos", lblAsympWeight.Caption), vbApplicationModal, ProgName
        CheckSetting = False
    End If

    ' algorithm
    If CLng(txtMaxEMIter.Text) <= 0 Then
        MsgBox GText("msgNotPos", lblMaxEMIter.Caption), vbApplicationModal, ProgName
        CheckSetting = False
    End If
    If CLng(txtMaxNRIter.Text) <= 0 Then
        MsgBox GText("msgNotPos", lblMaxNRIter.Caption), vbApplicationModal, ProgName
        CheckSetting = False
    End If
    If CDbl(txtPrecision.Text) <= 0 Then
        MsgBox GText("msgNotPos", lblPrecision.Caption), vbApplicationModal, ProgName
        CheckSetting = False
    End If
    If CDbl(txtKernelFactor.Text) <= 0 Then
        MsgBox GText("msgNotPos", lblKernelFactor.Caption), vbApplicationModal, ProgName
        CheckSetting = False
    End If
    If CDbl(txtPenalizedFactor.Text) <= 0 Then
        MsgBox GText("msgNotPos", lblPenalizedFactor.Caption), vbApplicationModal, ProgName
        CheckSetting = False
    End If

    ' quadratures
    If CLng(txtNbrQuad.Text) <= 0 Then
        MsgBox GText("msgNotPos", lblNbrQuad.Caption), vbApplicationModal, ProgName
        CheckSetting = False
    ElseIf Abs(Exp(Log(2) * Round(Log(CLng(txtNbrQuad.Text)) / Log(2))) _
        - CLng(txtNbrQuad.Text)) > 0.0001 Then
        MsgBox GText("msgNotPow2", lblNbrQuad.Caption), vbApplicationModal, ProgName
        CheckSetting = False
    End If
    If CDbl(txtQuadFrom.Text) >= CDbl(txtQuadTo.Text) Then
        MsgBox GText("msgLessThan", lblQuadFrom.Caption, lblQuadTo.Caption), vbApplicationModal, ProgName
        CheckSetting = False
    End If

    ' models
    If CDbl(txtFixedSlope.Text) <= 0 Then
        MsgBox GText("msgNotPos", lblFixedSlope.Caption), vbApplicationModal, ProgName
        CheckSetting = False
    End If

End Function

Private Sub ApplySetting()
    
    ' we convert the user inputs with locale dependant functions
    
    ' language
    LangCode = cmbLanguage.ListIndex + 1
    AbilName = txtAbilName.Text

    ' priors
    If chkSlopePrior.Value Then SlopePrior = 1 Else SlopePrior = 0
    If chkThreshPrior.Value Then ThreshPrior = 1 Else ThreshPrior = 0
    If chkAsympPrior.Value Then AsympPrior = 1 Else AsympPrior = 0
    SlopeMean = CDbl(txtSlopeMean.Text)
    SlopeDev = CDbl(txtSlopeDev.Text)
    ThreshMean = CDbl(txtThreshMean.Text)
    ThreshDev = CDbl(txtThreshDev.Text)
    AsympMean = CDbl(txtAsympMean.Text)
    AsympWeight = CDbl(txtAsympWeight.Text)

    ' algorithm
    MaxEMiter = CLng(txtMaxEMIter.Text)
    MaxNRiter = CLng(txtMaxNRIter.Text)
    Precision = CDbl(txtPrecision.Text)
    KernelFactor = CDbl(txtKernelFactor.Text)
    PenalizedFactor = CDbl(txtPenalizedFactor.Text)
    If chkGrouping.Value Then Grouping = 1 Else Grouping = 0
    AbilEstim = cmbAbilEstim.Value
    
    ' quadratures
    NbrQuad = CLng(txtNbrQuad.Text)
    QuadFrom = CDbl(txtQuadFrom.Text)
    QuadTo = CDbl(txtQuadTo.Text)

    ' models
    FixedSlope = CDbl(txtFixedSlope.Text)
    If chkNormalOgive.Value Then NormalOgive = 1 Else NormalOgive = 0
    If chkPolyserialCorr.Value Then PolyserialCorr = 1 Else PolyserialCorr = 0
End Sub

Private Sub btnCancel_Click()
    Me.Hide
End Sub

Private Sub btnHelp_Click()
    WirtHelp
End Sub

Private Sub btnOk_Click()
    On Error GoTo errorEnd
    
    If CheckSetting() Then
        ApplySetting
        WriteSetting
        Me.Hide
    End If

    Exit Sub

errorEnd:
    MsgBox GText("msgError", Err.Description), vbCritical, ProgName
End Sub

Private Sub chkSlopePrior_Click()
    lblSlopeMean.Enabled = chkSlopePrior.Value
    lblSlopeDev.Enabled = chkSlopePrior.Value
    txtSlopeMean.Enabled = chkSlopePrior.Value
    txtSlopeDev.Enabled = chkSlopePrior.Value
End Sub

Private Sub chkThreshPrior_Click()
    lblThreshMean.Enabled = chkThreshPrior.Value
    lblThreshDev.Enabled = chkThreshPrior.Value
    txtThreshMean.Enabled = chkThreshPrior.Value
    txtThreshDev.Enabled = chkThreshPrior.Value
End Sub

Private Sub chkAsympPrior_Click()
    lblAsympMean.Enabled = chkAsympPrior.Value
    lblAsympWeight.Enabled = chkAsympPrior.Value
    txtAsympMean.Enabled = chkAsympPrior.Value
    txtAsympWeight.Enabled = chkAsympPrior.Value
End Sub

Private Sub Pages_Change()

End Sub

Private Sub UserForm_Activate()
    ReadSetting
    
    ' get the localized string
    Me.Caption = ProgName
    btnCancel.Caption = GText("btnCancel")
    btnHelp.Caption = GText("btnHelp")
    btnOk.Caption = GText("btnOk")
    Pages.Pages("pgLang").Caption = GText("pgLang")
    Pages.Pages("pgPriors").Caption = GText("pgPriors")
    Pages.Pages("pgAlgo").Caption = GText("pgAlgo")
    Pages.Pages("pgQuad").Caption = GText("pgQuad")
    Pages.Pages("pgModels").Caption = GText("pgModels")
    lblLanguage.Caption = GText("lblLanguage")
    lblAbilName.Caption = GText("lblAbilName")
    chkSlopePrior.Caption = GText("chkSlopePrior")
    chkThreshPrior.Caption = GText("chkThreshPrior")
    chkAsympPrior.Caption = GText("chkAsympPrior")
    lblSlopeMean.Caption = GText("lblSlopeMean")
    lblSlopeDev.Caption = GText("lblSlopeDev")
    lblThreshMean.Caption = GText("lblThreshMean")
    lblThreshDev.Caption = GText("lblThreshDev")
    lblAsympMean.Caption = GText("lblAsympMean")
    lblAsympWeight.Caption = GText("lblAsympWeight")
    lblMaxEMIter.Caption = GText("lblMaxEMIter")
    lblMaxNRIter.Caption = GText("lblMaxNRIter")
    lblPrecision.Caption = GText("lblPrecision")
    lblKernelFactor.Caption = GText("lblKernelFactor")
    lblPenalizedFactor.Caption = GText("lblPenalizedFactor")
    chkGrouping.Caption = GText("chkGrouping")
    lblNbrQuad.Caption = GText("lblNbrQuad")
    lblQuadFrom.Caption = GText("lblQuadFrom")
    lblQuadTo.Caption = GText("lblQuadTo")
    lblFixedSlope.Caption = GText("lblFixedSlope")
    chkNormalOgive.Caption = GText("chkNormalOgive")
    chkPolyserialCorr.Caption = GText("chkPolyserialCorr")
    lblAbilEstim.Caption = GText("lblAbilEstim")

    ' language
    Dim i As Integer
    cmbLanguage.Clear
    For i = 1 To NbrLang
        cmbLanguage.AddItem ThisWorkbook.Worksheets("gettext").Range("Language").Cells(1, i)
    Next i
    cmbLanguage.ListIndex = LangCode - 1
    txtAbilName.Text = AbilName
    
    ' priors
    chkSlopePrior.Value = (SlopePrior <> 0)
    chkThreshPrior.Value = (ThreshPrior <> 0)
    chkAsympPrior.Value = (AsympPrior <> 0)
    txtSlopeMean.Text = SlopeMean
    txtSlopeDev.Text = SlopeDev
    txtThreshMean.Text = ThreshMean
    txtThreshDev.Text = ThreshDev
    txtAsympMean.Text = AsympMean
    txtAsympWeight.Text = AsympWeight
    lblSlopeMean.Enabled = chkSlopePrior.Value
    lblSlopeDev.Enabled = chkSlopePrior.Value
    lblThreshMean.Enabled = chkThreshPrior.Value
    lblThreshDev.Enabled = chkThreshPrior.Value
    lblAsympMean.Enabled = chkAsympPrior.Value
    lblAsympWeight.Enabled = chkAsympPrior.Value
    txtSlopeMean.Enabled = chkSlopePrior.Value
    txtSlopeDev.Enabled = chkSlopePrior.Value
    txtThreshMean.Enabled = chkThreshPrior.Value
    txtThreshDev.Enabled = chkThreshPrior.Value
    txtAsympMean.Enabled = chkAsympPrior.Value
    txtAsympWeight.Enabled = chkAsympPrior.Value
    
    ' algorithm
    txtMaxEMIter.Text = MaxEMiter
    txtMaxNRIter.Text = MaxNRiter
    txtPrecision.Text = Precision
    txtKernelFactor.Text = KernelFactor
    txtPenalizedFactor.Text = PenalizedFactor
    chkGrouping.Value = (Grouping <> 0)
    cmbAbilEstim.Clear
    cmbAbilEstim.AddItem GText("optEAP")
    cmbAbilEstim.AddItem GText("optWMLE")
    cmbAbilEstim.Value = AbilEstim
    
    ' quadratures
    txtNbrQuad.Text = NbrQuad
    txtQuadFrom.Text = QuadFrom
    txtQuadTo.Text = QuadTo
    
    ' models
    txtFixedSlope.Text = FixedSlope
    chkNormalOgive.Value = (NormalOgive <> 0)
    chkPolyserialCorr.Value = (PolyserialCorr <> 0)
End Sub
