VERSION 5.00
Begin {C62A69F0-16DC-11CE-9E98-00AA00574A4F} frmModel 
   Caption         =   "eirt"
   ClientHeight    =   7020
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   7905
   OleObjectBlob   =   "frmModel.frx":0000
   StartUpPosition =   1  'CenterOwner
End
Attribute VB_Name = "frmModel"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

' Copyright (C) 2007 Stephane Germain <stephane.germain@gmail.com>
'
' This program is free software; you can redistribute it and/or modify
' it under the terms of the GNU General Public License as published by
' the Free Software Foundation; either version 2 of the License, or (at
' your option) any later version.
'
' This program is distributed in the hope that it will be useful, but
' WITHOUT ANY WARRANTY; without even the implied warranty of
' MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
' General Public License for more details.
'
' You should have received a copy of the GNU General Public License
' along with this program; if not, write to the Free Software
' Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

Option Explicit
Option Base 0

Private Sub btnBack_Click()
    Me.Hide
    StepNum = StepNum - 1
    frmData.Show
End Sub

Private Sub btnCancel_Click()
    Me.Hide
End Sub

Private Sub btnHelp_Click()
    WirtHelp
End Sub

Private Sub btnNext_Click()
    On Error GoTo errorEnd

    PLM1 = optPLM1.Value
    PLM2 = optPLM2.Value
    PLM3 = optPLM3.Value
    NominalModel = optNominalModel.Value
    GradedModel = optGradedModel.Value
    Kernel = optKernel.Value
    Penalized = optPenalized.Value

    If Not (PLM1 Or PLM2 Or PLM3 Or NominalModel Or GradedModel Or _
        Kernel Or Penalized) Then
        MsgBox GText("msgChooseModel"), vbApplicationModal, ProgName
        GoTo retryEnd
    End If

    ReDim Models(NbrItem) As Long
    ReDim DataTypes(NbrItem) As Long
    Dim i As Long
    For i = 1 To NbrItem
        If MC Then
            DataTypes(i) = 4
        ElseIf Graded Then
            DataTypes(i) = 5
        Else
            DataTypes(i) = 0
        End If
        
        If NominalModel Then
            Models(i) = 4
        ElseIf GradedModel Then
            Models(i) = 5
        Else
            Models(i) = 0
        End If
    Next i

normalEnd:
    Me.Hide
    StepNum = StepNum + 1
    On Error GoTo 0
    frmReport.Show
    
retryEnd:
    Exit Sub

errorEnd:
    MsgBox GText("msgError", Err.Description), vbCritical, ProgName
End Sub



Private Sub UserForm_Activate()
    ReadSetting
    Me.Caption = ProgName
    ' get the localized string
    btnBack.Caption = GText("btnBack")
    btnNext.Caption = GText("btnNext")
    btnHelp.Caption = GText("btnHelp")
    btnCancel.Caption = GText("btnCancel")
    lblStep.Caption = GText("lblStep", StepNum, NbrStep)
    lblInstruction.Caption = GText("lblInstructionModel")
    optPLM1.Caption = GText("optPLM1")
    optPLM2.Caption = GText("optPLM2")
    optPLM3.Caption = GText("optPLM3")
    optNominalModel.Caption = GText("optNominalModel")
    optGradedModel.Caption = GText("optGradedModel")
    optKernel.Caption = GText("optKernel")
    optPenalized.Caption = GText("optPenalized")
    optPLM1.ControlTipText = GText("ttoptPLM1")
    optPLM2.ControlTipText = GText("ttoptPLM2")
    optPLM3.ControlTipText = GText("ttoptPLM3")
    optNominalModel.ControlTipText = GText("ttoptNominalModel")
    optGradedModel.ControlTipText = GText("ttoptGradedModel")
    optKernel.ControlTipText = GText("ttoptKernel")
    optPenalized.ControlTipText = GText("ttoptPenalized")
    
    ' disable the models depending on the data type
    If Binary Then
        optPLM1.Enabled = True
        optPLM2.Enabled = True
        optPLM3.Enabled = True
        optNominalModel.Enabled = False
        optGradedModel.Enabled = False
        optKernel.Enabled = True
        optPenalized.Enabled = True
        optNominalModel.Value = False
        optGradedModel.Value = False
        If Not (optPLM1.Value Or optPLM3.Value _
            Or optPenalized.Value Or optKernel.Value) Then
            optPLM2.Value = True
        End If
    ElseIf MC Then
        optPLM1.Enabled = True
        optPLM2.Enabled = True
        optPLM3.Enabled = True
        optNominalModel.Enabled = True
        optGradedModel.Enabled = False
        optKernel.Enabled = True
        optPenalized.Enabled = True
        optPLM1.Value = False
        optPLM2.Value = False
        optPLM3.Value = False
        optGradedModel.Value = False
        If Not (optPenalized.Value Or optKernel.Value) Then
            optNominalModel.Value = True
        End If
    ElseIf Graded Then
        optPLM1.Enabled = False
        optPLM2.Enabled = False
        optPLM3.Enabled = False
        optNominalModel.Enabled = True
        optGradedModel.Enabled = True
        optKernel.Enabled = True
        optPenalized.Enabled = True
        optPLM1.Value = False
        optPLM2.Value = False
        optPLM3.Value = False
        If Not (optNominalModel.Value Or optPenalized.Value Or optKernel.Value) Then
            optGradedModel.Value = True
        End If
    End If
End Sub

Private Sub UserForm_Initialize()
End Sub

